<?php
error_reporting(E_ALL);

define('IN_MYBB', 1);

require "./global.php";
$lang->load('missmail');
addacpnav($lang->nav_users, "users.php?".SID);
addacpnav($lang->missmail);

checkadminpermissions("caneditusers");
logadmin();

if(!$mybb->input['action'] && $mybb->input['action'] != "do_missmail")
{
	
	if(!isset($mybb->settings['missmailenable']))
	{
		cperror("<div align=\"center\">".$lang->deactivated."</div>", $lang->error_message);
		exit;
	}
	elseif($mybb->settings['missmailenable'] == "off")
	{
		cperror("<div align=\"center\">".$lang->disabled."</div>", $lang->error_message);
		exit;
	}
	
	cpheader();
	startform("missmail.php", '', "do_missmail");
	starttable();
	tableheader($lang->missmail);
	tablesubheader($lang->options);
	makeinputcode($lang->per_page, "searchop[perpage]", "500", "10");
	makeinputcode($lang->days, "searchop[days]", "30", "10");
	makeinputcode($lang->from, "searchop[from]", $mybb->settings['adminemail']);
	makeinputcode($lang->subject, "searchop[subject]");
	maketextareacode($lang->message, "searchop[message]", '', 10, 50);
	endtable();
	endform($lang->send_mail, $lang->reset_button);
	cpfooter();
}
	
if($mybb->input['action'] == "do_missmail")
{
	$conditions = "1=1";

	$searchop = $mybb->input['searchop'];
	if(!$searchop['days'] || $searchop['days'] <= "0")
	{
		$time = time() - (60 * 60 * 24 * 30);
		$conditions .= " AND lastvisit<".$time;
	}
	else
	{
		$time = time() - (60 * 60 * 24 * $searchop['days']);
		$conditions .= " AND lastvisit<".$time;
	}

	if(!$searchop['perpage'])
	{
		$searchop['perpage'] = "500";
	}
	if(!$searchop['page'])
	{
		$searchop['page'] = "1";
		$searchop['start'] = "0";
	}
	else
	{
		$searchop['start'] = ($searchop['page']-1) * $searchop['perpage'];
	}
	$searchop['page']++;
	
	if(!trim($mybb->input['searchop']['subject']))
	{
		cperror($lang->error_missing_subject);
	}
	if(!trim($mybb->input['searchop']['message']))
	{
		cperror($lang->error_missing_subject);
	}

	$query = $db->query("SELECT COUNT(*) AS results FROM ".TABLE_PREFIX."users WHERE $conditions ORDER BY uid");
	$num = $db->fetch_array($query);
	$num['results'] -= $searchop['start'];
	if(!$num['results'])
	{
		cpmessage($lang->error_no_users);
	}
	else
	{
		cpheader();
		starttable();
		tableheader($lang->missmail);
		$lang->results_matching = sprintf($lang->results_matching, $num['results']);
		tablesubheader($lang->results_matching);
		$bgcolor = getaltbg();
		echo "<tr>\n<td class=\"$bgcolor\" valign=\"top\">\n";
		@set_time_limit(0);
		$query = $db->query("SELECT * FROM ".TABLE_PREFIX."users WHERE $conditions ORDER BY uid LIMIT ".intval($searchop['start']).", ".intval($searchop['perpage']));
    	while($user = $db->fetch_array($query))
		{
			$sendmessage = $searchop['message'];
			$sendmessage = str_replace("{uid}", $user['uid'], $sendmessage);
			$sendmessage = str_replace("{username}", $user['username'], $sendmessage);
			$sendmessage = str_replace("{email}", $user['email'], $sendmessage);
			$sendmessage = str_replace("{bbname}", $mybb->settings['bbname'], $sendmessage);
			$sendmessage = str_replace("{bburl}", $mybb->settings['bburl'], $sendmessage);

			if($user['email'] != '')
			{
				my_mail($user['email'], $searchop['subject'], $sendmessage, $searchop['from']);
				echo sprintf($lang->email_sent, $user['username']);
			}
			else
			{
				echo sprintf($lang->not_sent, $user['username']);
			}
			echo "<br />";
		}
		echo $lang->done;
		echo "</td>\n</tr>\n";
		endtable();
		if($num['results'] > $searchop['perpage'])
		{
			startform("missmail.php", '', "do_missmail");
			foreach($searchop as $key => $val)
			{
				$hiddens .= "\n<input type=\"hidden\" name=\"searchop[$key]\" value=\"".htmlspecialchars_uni($val)."\" />";
			}
			echo $hiddens;
			endform($lang->next_page, '');
		}
		cpfooter();
	}
}
?>